/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import com.mojang.datafixers.util.Either;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.TooltipDisplay;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Matrix3x2fStack;
import squeek.appleskin.ModConfig;
import squeek.appleskin.api.event.TooltipOverlayEvent;
import squeek.appleskin.helpers.ColorHelper;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.KeyHelper;
import squeek.appleskin.helpers.TextureHelper;

public class TooltipOverlayHandler {
    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new TooltipOverlayHandler());
    }

    public static void register(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(FoodTooltip.class, FoodTooltipRenderer::new);
    }

    @SubscribeEvent
    public void gatherTooltips(RenderTooltipEvent.GatherComponents event) {
        if (event.isCanceled()) {
            return;
        }
        ItemStack hoveredStack = event.getItemStack();
        Minecraft mc = Minecraft.getInstance();
        if (!TooltipOverlayHandler.shouldShowTooltip(hoveredStack, (Player)mc.player)) {
            return;
        }
        FoodHelper.QueriedFoodResult queriedFoodResult = FoodHelper.query(hoveredStack, (Player)mc.player);
        if (queriedFoodResult == null) {
            return;
        }
        FoodProperties defaultFood = queriedFoodResult.defaultFoodProperties;
        FoodProperties modifiedFood = queriedFoodResult.modifiedFoodProperties;
        TooltipOverlayEvent.Pre prerenderEvent = new TooltipOverlayEvent.Pre(hoveredStack, defaultFood, modifiedFood);
        NeoForge.EVENT_BUS.post((Event)prerenderEvent);
        if (prerenderEvent.isCanceled()) {
            return;
        }
        FoodTooltip foodTooltip = new FoodTooltip(prerenderEvent.itemStack, defaultFood, modifiedFood, queriedFoodResult.consumable, (Player)mc.player);
        if (foodTooltip.shouldRenderHungerBars()) {
            event.getTooltipElements().add(Either.right((Object)foodTooltip));
        }
    }

    private static boolean shouldShowTooltip(ItemStack hoveredStack, Player player) {
        boolean shouldShowTooltip;
        if (hoveredStack.isEmpty()) {
            return false;
        }
        if (((TooltipDisplay)hoveredStack.getOrDefault(DataComponents.TOOLTIP_DISPLAY, (Object)TooltipDisplay.DEFAULT)).hideTooltip()) {
            return false;
        }
        boolean bl = shouldShowTooltip = (Boolean)ModConfig.SHOW_FOOD_VALUES_IN_TOOLTIP.get() != false && KeyHelper.isShiftKeyDown() || (Boolean)ModConfig.ALWAYS_SHOW_FOOD_VALUES_TOOLTIP.get() != false;
        if (!shouldShowTooltip) {
            return false;
        }
        return FoodHelper.isFood(hoveredStack, player);
    }

    static class FoodTooltip
    implements TooltipComponent {
        private FoodProperties defaultFood;
        private FoodProperties modifiedFood;
        private Consumable consumable;
        private int biggestHunger;
        private float biggestSaturationIncrement;
        private int hungerBars;
        private String hungerBarsText;
        private int saturationBars;
        private String saturationBarsText;
        private ItemStack itemStack;

        FoodTooltip(ItemStack itemStack, FoodProperties defaultFood, FoodProperties modifiedFood, Consumable consumable, Player player) {
            this.itemStack = itemStack;
            this.defaultFood = defaultFood;
            this.modifiedFood = modifiedFood;
            this.consumable = consumable;
            this.biggestHunger = Math.max(defaultFood.nutrition(), modifiedFood.nutrition());
            this.biggestSaturationIncrement = Math.max(defaultFood.saturation(), modifiedFood.saturation());
            this.hungerBars = (int)Math.ceil((float)Math.abs(this.biggestHunger) / 2.0f);
            if (this.hungerBars > 10) {
                this.hungerBarsText = "x" + (this.biggestHunger < 0 ? -1 : 1) * this.hungerBars;
                this.hungerBars = 1;
            }
            this.saturationBars = (int)Math.ceil(Math.abs(this.biggestSaturationIncrement) / 2.0f);
            if (this.saturationBars > 10 || this.saturationBars == 0) {
                this.saturationBarsText = "x" + (this.biggestSaturationIncrement < 0.0f ? -1 : 1) * this.saturationBars;
                this.saturationBars = 1;
            }
        }

        boolean shouldRenderHungerBars() {
            return this.hungerBars > 0;
        }
    }

    static class FoodTooltipRenderer
    implements ClientTooltipComponent {
        private FoodTooltip foodTooltip;

        FoodTooltipRenderer(FoodTooltip foodTooltip) {
            this.foodTooltip = foodTooltip;
        }

        public int getHeight(Font font) {
            return 20;
        }

        public int getWidth(Font font) {
            int hungerBarsWidth = this.foodTooltip.hungerBars * 9;
            if (this.foodTooltip.hungerBarsText != null) {
                hungerBarsWidth += font.width(this.foodTooltip.hungerBarsText);
            }
            int saturationBarsWidth = this.foodTooltip.saturationBars * 7;
            if (this.foodTooltip.saturationBarsText != null) {
                saturationBarsWidth += font.width(this.foodTooltip.saturationBarsText);
            }
            return Math.max(hungerBarsWidth, saturationBarsWidth) + 2;
        }

        public void renderImage(Font font, int x, int y, int width, int height, GuiGraphics guiGraphics) {
            ItemStack itemStack = this.foodTooltip.itemStack;
            Minecraft mc = Minecraft.getInstance();
            if (!TooltipOverlayHandler.shouldShowTooltip(itemStack, (Player)mc.player)) {
                return;
            }
            Screen gui = mc.screen;
            if (gui == null) {
                return;
            }
            FoodProperties defaultFood = this.foodTooltip.defaultFood;
            FoodProperties modifiedFood = this.foodTooltip.modifiedFood;
            TooltipOverlayEvent.Render renderEvent = new TooltipOverlayEvent.Render(itemStack, x, y, guiGraphics, defaultFood, modifiedFood);
            NeoForge.EVENT_BUS.post((Event)renderEvent);
            if (renderEvent.isCanceled()) {
                return;
            }
            x = renderEvent.x;
            y = renderEvent.y;
            guiGraphics = renderEvent.guiGraphics;
            int offsetX = x;
            int offsetY = y;
            int defaultHunger = defaultFood.nutrition();
            int modifiedHunger = modifiedFood.nutrition();
            offsetX += (this.foodTooltip.hungerBars - 1) * 9;
            boolean isRotten = FoodHelper.isRotten(this.foodTooltip.consumable);
            for (int i = 0; i < this.foodTooltip.hungerBars * 2; i += 2) {
                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, TextureHelper.FOOD_EMPTY_TEXTURE, offsetX, offsetY, 9, 9);
                FoodOutline outline = FoodOutline.get(modifiedHunger, defaultHunger, i);
                if (outline != FoodOutline.NORMAL) {
                    guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, TextureHelper.HUNGER_OUTLINE_SPRITE, offsetX, offsetY, 9, 9, outline.argb());
                }
                boolean isDefaultHalf = defaultHunger - 1 == i;
                ResourceLocation defaultFoodIcon = TextureHelper.getFoodTexture(isRotten, isDefaultHalf ? TextureHelper.FoodType.HALF : TextureHelper.FoodType.FULL);
                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, defaultFoodIcon, offsetX, offsetY, 9, 9, ColorHelper.argbFromRGBA(1.0f, 1.0f, 1.0f, 0.25f));
                if (modifiedHunger > i) {
                    boolean isModifiedHalf = modifiedHunger - 1 == i;
                    ResourceLocation modifiedFoodIcon = TextureHelper.getFoodTexture(isRotten, isModifiedHalf ? TextureHelper.FoodType.HALF : TextureHelper.FoodType.FULL);
                    guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, modifiedFoodIcon, offsetX, offsetY, 9, 9);
                }
                offsetX -= 9;
            }
            if (this.foodTooltip.hungerBarsText != null) {
                Matrix3x2fStack poseStack = guiGraphics.pose();
                poseStack.pushMatrix();
                poseStack.translate((float)(offsetX += 18), (float)offsetY);
                poseStack.scale(0.75f, 0.75f);
                guiGraphics.drawString(font, this.foodTooltip.hungerBarsText, 2, 2, -5592406);
                poseStack.popMatrix();
            }
            offsetX = x;
            offsetY += 10;
            float modifiedSaturationIncrement = modifiedFood.saturation();
            float absModifiedSaturationIncrement = Math.abs(modifiedSaturationIncrement);
            offsetX += (this.foodTooltip.saturationBars - 1) * 7;
            for (int i = 0; i < this.foodTooltip.saturationBars * 2; i += 2) {
                int color;
                float effectiveSaturationOfBar = (absModifiedSaturationIncrement - (float)i) / 2.0f;
                boolean shouldBeFaded = absModifiedSaturationIncrement <= (float)i;
                int n = color = shouldBeFaded ? ColorHelper.argbFromRGBA(1.0f, 1.0f, 1.0f, 0.5f) : ColorHelper.argbFromRGBA(1.0f, 1.0f, 1.0f, 1.0f);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TextureHelper.MOD_ICONS, offsetX, offsetY, effectiveSaturationOfBar >= 1.0f ? 21.0f : ((double)effectiveSaturationOfBar > 0.5 ? 14.0f : ((double)effectiveSaturationOfBar > 0.25 ? 7.0f : (effectiveSaturationOfBar > 0.0f ? 0.0f : 28.0f))), modifiedSaturationIncrement >= 0.0f ? 27.0f : 34.0f, 7, 7, 256, 256, color);
                offsetX -= 7;
            }
            if (this.foodTooltip.saturationBarsText != null) {
                Matrix3x2fStack poseStack = guiGraphics.pose();
                poseStack.pushMatrix();
                poseStack.translate((float)(offsetX += 14), (float)offsetY);
                poseStack.scale(0.75f, 0.75f);
                guiGraphics.drawString(font, this.foodTooltip.saturationBarsText, 2, 1, -5592406);
                poseStack.popMatrix();
            }
        }
    }

    static enum FoodOutline {
        NEGATIVE,
        EXTRA,
        NORMAL,
        PARTIAL,
        MISSING;


        public int argb() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> ColorHelper.argbFromRGBA(1.0f, 1.0f, 1.0f, 1.0f);
                case 1 -> ColorHelper.argbFromRGBA(0.06f, 0.32f, 0.02f, 1.0f);
                case 2 -> ColorHelper.argbFromRGBA(0.0f, 0.0f, 0.0f, 1.0f);
                case 3 -> ColorHelper.argbFromRGBA(0.53f, 0.21f, 0.08f, 1.0f);
                case 4 -> ColorHelper.argbFromRGBA(0.62f, 0.0f, 0.0f, 0.5f);
            };
        }

        public static FoodOutline get(int modifiedFoodHunger, int defaultFoodHunger, int i) {
            if (modifiedFoodHunger < 0) {
                return NEGATIVE;
            }
            if (modifiedFoodHunger > defaultFoodHunger && defaultFoodHunger <= i) {
                return EXTRA;
            }
            if (modifiedFoodHunger > i + 1 || defaultFoodHunger == modifiedFoodHunger) {
                return NORMAL;
            }
            if (modifiedFoodHunger == i + 1) {
                return PARTIAL;
            }
            return MISSING;
        }
    }
}

